//////////////////////////////////////////////////////
//	File	:	"CPlayer.cpp"
//	Author	:	Alyssa Dettling (AD)
//	Purpose	:	Deals with defining a player's functionality
//////////////////////////////////////////////////////

#include "CPlayer.h"

#include "CSGD_TextureManager.h"
#include "CSGD_Direct3D.h"
#include "CSGD_DirectInput.h"
#include "SGD_Math.h"

#include "CSGD_EventSystem.h"
#include "CSGD_MessageSystem.h"
#include "CGame.h"


CPlayer::CPlayer()
{
	m_szName = "No Name";

	m_pCurrentAnimation = new CAnimInstance();
	m_pCurrentAnimation->SetSpriteFile("Idle.png");
	m_pCurrentAnimation->SetCurrentAnim("Idle"); 

	// initializing the width and height for collision detection
	SetWidth(m_pCurrentAnimation->GetCurrentCollRect().right - m_pCurrentAnimation->GetCurrentCollRect().left);
	SetHeight(m_pCurrentAnimation->GetCurrentCollRect().bottom - m_pCurrentAnimation->GetCurrentCollRect().top);

	m_nLine = 0;

	m_fLastShotTime = 0.0f;
}

CPlayer::~CPlayer()
{
	delete m_pCurrentAnimation;
}

bool CPlayer::Input()
{
	if(m_bIsDead)
		return true;

	CSGD_DirectInput* pDI = CSGD_DirectInput::GetInstance();
	
	//temporry numbers to test input
	if(pDI->GetBufferedKey(DIK_UP) || pDI->GetBufferedKey(DIK_W))
	{
		m_nLine--;
	}
	

	if(pDI->GetBufferedKey(DIK_DOWN) || pDI->GetBufferedKey(DIK_S))
	{
		m_nLine++;
	}
	
	if(pDI->GetBufferedKey(DIK_1))
		m_nLine = 0;
	else if(pDI->GetBufferedKey(DIK_2))
		m_nLine = 1;
	else if(pDI->GetBufferedKey(DIK_3))
		m_nLine = 2;
	else if(pDI->GetBufferedKey(DIK_4))
		m_nLine = 3;

	if(m_nLine < 0)
		m_nLine = 3;

	if(m_nLine > 3)
		m_nLine = 0;

	if(pDI->GetBufferedKey(DIK_SPACE) && m_fLastShotTime > 0.3f )
	{
		m_fLastShotTime = 0.0f;
		m_pCurrentAnimation->SetSpriteFile("Attack.png");
		m_pCurrentAnimation->SetCurrentAnim("Attack");

		CSGD_MessageSystem::GetInstance()->SendMsg(new CCreateBulletMessage(this));
	}
	
	return true;
}

void CPlayer::Update(float fElapsedTime)
{
	m_fLastShotTime += fElapsedTime;
	//SetPosY(0 + m_nLine * CGame::GetInstance()->GetHeight()/4.0f);
	if(m_nLine == 0)
		SetPosY(45);
	else if(m_nLine == 1)
		SetPosY(155);
	else if(m_nLine == 2)
		SetPosY(265);
	else if(m_nLine == 3)
		SetPosY(375);

	if(m_pCurrentAnimation->GetCurrentFrameIndex() == 3)
	{
		m_pCurrentAnimation->SetSpriteFile("Idle.png");
		m_pCurrentAnimation->SetCurrentAnim("Idle"); 
	}

	m_pCurrentAnimation->Update(fElapsedTime);
}

void CPlayer::Render()
{
	//CBase::Render();

/////////////////////////////////////////////////////////////////////////
 	////Draws Collision Rect
	//CSGD_Direct3D::GetInstance()->SpriteEnd();
	//CSGD_Direct3D::GetInstance()->DeviceEnd();
	//CSGD_Direct3D::GetInstance()->DrawRect(GetCollisionRect(), 0, 0, 0);
	//RECT temp = {GetPosX()-5,GetPosY()-5,GetPosX()+5,GetPosY()+5};
	//CSGD_Direct3D::GetInstance()->DrawRect(temp, 255,255,255 );
	//CSGD_Direct3D::GetInstance()->DeviceBegin();
	//CSGD_Direct3D::GetInstance()->SpriteBegin();
	//CSGD_Direct3D::GetInstance()->SpriteEnd();
	//CSGD_Direct3D::GetInstance()->DeviceEnd();
//////////////////////////////////////////////////////////////////////////

	CSGD_TextureManager::GetInstance()->DrawTexture(CAnimationManager::GetInstance()->GetSpriteSheet(m_pCurrentAnimation->GetSpriteFile())->GetImageID(), 
		GetPosX(), GetPosY(), 0.1f, GetScale(), GetScale(), &m_pCurrentAnimation->GetCurrentFrameRect());
	
}

void CPlayer::HandleEvent(CEvent* pEvent)
{
	if(this == pEvent->GetParam())
	{
		
	}
}
